/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: PNIODCP_Functionlist.h $
   Last Modification:
    $Author: Matthias $
    $Modtime: 23.01.07 10:52 $
    $Revision: 1 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    PNIO DCP
    Task function list for configuration file

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------

**************************************************************************************/
/**
 * @file PNIODCP_Functionlist.h
 * @brief PNIO DCP - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_PNM_PNIODCP</code>
 * of task.
 */
#ifndef __PNM_PNIO_DCP_FUNCTIONLIST_H
#define __PNM_PNIO_DCP_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_PNM_PNIODCP
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskEnter_PNM_PNIODCP
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define PNIO_DCP_STARTUP_PARAM_VERSION (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** task startup parameter */
typedef struct PNM_PNIO_DCP_STARTUPPARAMETER_Ttag  PNM_PNIO_DCP_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct PNM_PNIO_DCP_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_UINT32    ulTaskIdentifier;
  TLR_UINT32    ulParamVersion;

  /** maximum of sender protocol machine
   *
   * The member defines the maximum number of protocol machines, which
   * are used to send DCP requests. This means the maximum of
   *  - DCPMCS (multicast sender)
   *  - DCPUCS (unicast sender)
   */
  TLR_UINT    uiMaxSend;
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __PNM_PNIO_DCP_FUNCTIONLIST_H */
